/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.api;

import com.github.quiltservertools.ledger.Ledger;
import com.github.quiltservertools.ledger.api.CommandExtension;
import com.github.quiltservertools.ledger.api.DatabaseExtension;
import com.github.quiltservertools.ledger.api.LedgerExtension;
import com.github.quiltservertools.ledger.config.LedgerConfigKt;
import com.github.quiltservertools.libs.com.uchuhimo.konf.ConfigSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0006R\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/github/quiltservertools/ledger/api/ExtensionManager;", "", "Lcom/github/quiltservertools/ledger/api/LedgerExtension;", "extension", "", "failExtensionRegistration", "(Lcom/github/quiltservertools/ledger/api/LedgerExtension;)V", "Ljava/util/Optional;", "Lcom/github/quiltservertools/ledger/api/DatabaseExtension;", "getDatabaseExtensionOptional", "()Ljava/util/Optional;", "registerExtension", "", "Lcom/github/quiltservertools/ledger/api/CommandExtension;", "commands", "Ljava/util/List;", "getCommands", "()Ljava/util/List;", "databaseExtension", "Ljava/util/Optional;", "extensions", "<init>", "()V", "ledger"})
public final class ExtensionManager {
    @NotNull
    public static final ExtensionManager INSTANCE = new ExtensionManager();
    @NotNull
    private static final List<LedgerExtension> extensions = new ArrayList();
    @NotNull
    private static Optional<DatabaseExtension> databaseExtension;
    @NotNull
    private static final List<CommandExtension> commands;

    private ExtensionManager() {
    }

    @NotNull
    public final List<CommandExtension> getCommands() {
        return commands;
    }

    public final void registerExtension(@NotNull LedgerExtension extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        extensions.add(extension);
        if (extension instanceof DatabaseExtension) {
            if (databaseExtension.isEmpty()) {
                Optional<LedgerExtension> optional2 = Optional.of(extension);
                Intrinsics.checkNotNullExpressionValue(optional2, (String)"of(extension)");
                databaseExtension = optional2;
            } else {
                this.failExtensionRegistration(extension);
            }
        }
        if (extension instanceof CommandExtension) {
            commands.add((CommandExtension)extension);
        }
        Iterable $this$forEach$iv = extension.getConfigSpecs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConfigSpec it = (ConfigSpec)element$iv;
            boolean bl = false;
            LedgerConfigKt.getConfig().addSpec(it);
        }
    }

    private final void failExtensionRegistration(LedgerExtension extension) {
        Ledger.INSTANCE.getLogger().error("Unable to load extension " + extension.getIdentifier());
    }

    @NotNull
    public final Optional<DatabaseExtension> getDatabaseExtensionOptional() {
        return databaseExtension;
    }

    static {
        Optional optional2 = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional2, (String)"empty()");
        databaseExtension = optional2;
        commands = new ArrayList();
    }
}

